<?php
// See also "fmt - onrender actions run" test. Additionally checks if only a message
// (without embedded odc) is output on wrong heading structure.

class UtidaPager extends UWikiPagerStub {
  function ReadPage($file, $format = null) { return $GLOBALS['tidaIncludes'][$file]; }
}

class Utidadynamic_Root extends UWikiBaseAction {
  function IsDynamic($format, $params) { return true; }
  function Execute($format, $params) { }
}


  $GLOBALS['tidaIncludes'] = array('dyna' => '
%%(tidaDynamic; html)
<html>
%%',
                                   'heading' => '== level 1+1 = 2 ==');

  $doc = new UWikiDocument('{{Include dyna}}');
  $doc->settings = $settings;
  $doc->settings->pager = new UtidaPager;
  $doc->LoadMarkup('wacko');

  $doc->Parse();
  $html = $doc->ToHTML();

$expectedHTML = '
<a name="dyna" href="#dyna" title="#dyna" class="anchor include block-anchor">
¶
</a>
<div class="wackowiki format format-html">
<span class="format-name">html</span>
<!--notypo--><pre class="code"><span style="color: #000080;font-weight:bold;">&lt;html&gt;</span></pre><!--/notypo-->
</div>
';

  TestEquality( preg_replace('/(\r?\n)+/u', "\n", trim($html)), trim($expectedHTML) );

  $doc = new UWikiDocument("{{Include heading}}\n====level 3==");
  $doc->settings = $settings;
  $doc->settings->pager = new UtidaPager;
  $doc->LoadMarkup('wacko');

  $doc->Parse();
  $html = $doc->ToHTML();

$expectedHTML = '
<em class="format-error">{{Include}} must be followed by a heading with level not more (level 1 = topmost) than topmost heading of the included document. However, topmost embedded heading had level 2 while heading following {{Include}} was of level 3 (must be more than/equal to embedded\'s topmost).</em>
<h3>
level 3<a name="level_3" href="#level_3" title="#level_3" class="anchor">¶</a>
</h3>
';

  TestEquality( preg_replace('/(\r?\n)+/u', "\n", trim($html)), trim($expectedHTML) );
